/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.owl.ui.prefix.PrefixMapping;
import org.protege.editor.owl.ui.prefix.PrefixMappingEditor;
import org.protege.editor.owl.ui.prefix.PrefixMappingEditorViewImpl;
import org.protege.editor.owl.ui.prefix.PrefixMappingRenderer;
import org.protege.editor.owl.ui.prefix.PrefixMappingsView;
import org.protege.editor.owl.ui.prefix.PrefixesListSection;
import org.protege.editor.owl.ui.prefix.PrefixesListSectionRow;

public class PrefixList
extends MList
implements PrefixMappingsView {
    private static final String TITLE = "Edit Prefix";
    private List<PrefixMapping> prefixMappings = new ArrayList<PrefixMapping>();
    private PrefixMappingsView.PrefixMappingsChangedHandler changeHandler = () -> {};
    private PrefixMappingEditor editor = new PrefixMappingEditor(new PrefixMappingEditorViewImpl());

    public PrefixList() {
        this.setCellRenderer(new PrefixMappingRenderer());
    }

    @Override
    public void setPrefixMappings(@Nonnull List<PrefixMapping> prefixMappings) {
        this.prefixMappings.clear();
        this.prefixMappings.addAll(prefixMappings);
        this.refill();
    }

    @Override
    public void setPrefixMappingsChangedHandler(@Nonnull PrefixMappingsView.PrefixMappingsChangedHandler handler) {
        this.changeHandler = (PrefixMappingsView.PrefixMappingsChangedHandler)Preconditions.checkNotNull((Object)handler);
    }

    private void refill() {
        PrefixesListSection section = new PrefixesListSection();
        Stream<PrefixesListSection> header = Stream.of(section);
        Stream<PrefixesListSectionRow> rows = this.prefixMappings.stream().map(PrefixesListSectionRow::new).peek(row -> {
            row.setDeleteHandler(this::handleDelete);
            row.setEditHandler(this::handleEdit);
        });
        Stream<PrefixesListSectionRow> elements = Stream.concat(header, rows);
        this.setListData(elements.toArray());
    }

    private void handleDelete(@Nonnull PrefixMapping prefixMapping) {
        if (this.prefixMappings.remove(prefixMapping)) {
            this.refill();
            this.changeHandler.handlePrefixMappingsChanged();
        }
    }

    protected void handleAdd() {
        this.editor.clear();
        this.showEditorDialog().ifPresent(pm -> {
            if (!this.prefixMappings.contains(pm)) {
                this.prefixMappings.add((PrefixMapping)pm);
                this.refill();
                this.changeHandler.handlePrefixMappingsChanged();
            }
        });
    }

    private Optional<PrefixMapping> showEditorDialog() {
        int ret = JOptionPane.showConfirmDialog((Component)((Object)this), this.editor.asJComponent(), TITLE, 2, -1);
        if (ret == 0) {
            return this.editor.getPrefixMapping();
        }
        return Optional.empty();
    }

    private void handleEdit(@Nonnull PrefixMapping prefixMapping) {
        this.editor.setPrefixMapping(prefixMapping);
        int index = this.prefixMappings.indexOf(prefixMapping);
        this.showEditorDialog().ifPresent(pm -> {
            this.prefixMappings.set(index, (PrefixMapping)pm);
            this.refill();
            this.changeHandler.handlePrefixMappingsChanged();
        });
    }

    @Override
    @Nonnull
    public ImmutableList<PrefixMapping> getPrefixMappings() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof PrefixesListSectionRow)) continue;
            builder.add((Object)((PrefixesListSectionRow)element).getValue());
        }
        return builder.build();
    }
}

