/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Tile;

public class Area
extends FreeColGameObject {
    public static final String TAG = "area";
    public static final String PREFIX_PLAYER_STARTING_POSITION = "model.area.starting.";
    private String nameKey = null;
    private String name = null;
    private List<Tile> tiles = new ArrayList<Tile>();
    private static final String TILE_REFERENCE_TAG = "tileReference";
    private static final String NAME_KEY_TAG = "nameKey";
    private static final String NAME_TAG = "name";

    public Area(Game game) {
        super(game);
    }

    public Area(Game game, String id) {
        super(game, id);
    }

    public Area(Game game, String id, String nameKey) {
        super(game, id);
        this.nameKey = nameKey;
    }

    public Area(Game game, Area copyFrom) {
        super(game, copyFrom.getId());
        this.name = copyFrom.name;
        this.nameKey = copyFrom.nameKey;
        for (Tile copyFromTile : copyFrom.tiles) {
            this.tiles.add(game.getMap().getTile(copyFromTile.getX(), copyFromTile.getY()));
        }
    }

    public List<Tile> getTiles() {
        return Collections.unmodifiableList(this.tiles);
    }

    public void addTile(Tile tile) {
        this.tiles.add(tile);
    }

    public boolean containsTile(Tile tile) {
        return this.tiles.contains(tile);
    }

    public void removeTile(Tile tile) {
        this.tiles.remove(tile);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.nameKey != null) {
            throw new IllegalArgumentException("Cannot change the name of areas with a fixed nameKey.");
        }
        this.name = name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public boolean isEmpty() {
        return this.tiles.isEmpty();
    }

    public Color getColor() {
        if (this.getId().startsWith(PREFIX_PLAYER_STARTING_POSITION)) {
            String nationId = this.getId().substring(PREFIX_PLAYER_STARTING_POSITION.length());
            Nation nation = this.getGame().getSpecification().getAlreadyInitializedType(nationId, Nation.class);
            if (nation != null) {
                return nation.getColor();
            }
        }
        int hashCode = this.getId().hashCode();
        int r = hashCode % 256;
        int g = hashCode / 256 % 256;
        int b = hashCode / 65536 % 256;
        return new Color(r, g, b);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Area o = this.copyInCast(other, Area.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.tiles = game.updateRef(this.tiles);
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.nameKey != null) {
            xw.writeAttribute(NAME_KEY_TAG, this.nameKey);
        }
        if (this.name != null) {
            xw.writeAttribute(NAME_TAG, this.name);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Tile tile : this.tiles) {
            xw.writeStartElement(TILE_REFERENCE_TAG);
            xw.writeAttribute("id", tile.getId());
            xw.writeEndElement();
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.nameKey = xr.getAttribute(NAME_KEY_TAG, null);
        this.name = xr.getAttribute(NAME_TAG, null);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.tiles = new ArrayList<Tile>();
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (TILE_REFERENCE_TAG.equals(tag)) {
            this.tiles.add(xr.makeFreeColObject(this.getGame(), "id", Tile.class, true));
            xr.closeTag(TILE_REFERENCE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        return "[" + this.getId() + "]";
    }
}

